'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - Ultima Printers                         **/
'/**                                                                       **/
'/**  MODULE NAME  : Encoding.vb                                           **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Initialisation ==="

    Private Sub InitEncodingTab()
        InitBPCCombos()
        InitBPICombos()
        InitEncodingTypeCombo()
        InitCoercivityCombo()
    End Sub

    Private encodingkp As New Dictionary(Of SDK.EncodingSpec, String) From
    {
        {SDK.EncodingSpec.ISO, "ISO"},
        {SDK.EncodingSpec.JIS2, "JIS2"}
    }

    Private Sub InitEncodingTypeCombo()
        EncodingTypeCombo.DataSource = New BindingSource(encodingkp, Nothing)
        EncodingTypeCombo.DisplayMember = "Value"
        EncodingTypeCombo.ValueMember = "Key"
    End Sub

    Private coercivitykp As New Dictionary(Of SDK.Coercivity, String) From
    {
        {SDK.Coercivity.Default, "Default"},
        {SDK.Coercivity.HiCo, "HiCo"},
        {SDK.Coercivity.LoCo, "LoCo"}
    }

    Private Sub InitCoercivityCombo()
        CoercivityCombo.DataSource = New BindingSource(coercivitykp, Nothing)
        CoercivityCombo.DisplayMember = "Value"
        CoercivityCombo.ValueMember = "Key"
    End Sub

    Private bpckp As New Dictionary(Of SDK.BitsPerChar, String) From
    {
        {SDK.BitsPerChar.Default, "Default"},
        {SDK.BitsPerChar.BPC1, "1"},
        {SDK.BitsPerChar.BPC5, "5"},
        {SDK.BitsPerChar.BPC7, "7"}
    }

    Private Sub InitBPCCombos()
        T1_BPCCombo.DataSource = New BindingSource(bpckp, Nothing)
        T1_BPCCombo.DisplayMember = "Value"
        T1_BPCCombo.ValueMember = "Key"
        T2_BPCCombo.DataSource = New BindingSource(bpckp, Nothing)
        T2_BPCCombo.DisplayMember = "Value"
        T2_BPCCombo.ValueMember = "Key"
        T3_BPCCombo.DataSource = New BindingSource(bpckp, Nothing)
        T3_BPCCombo.DisplayMember = "Value"
        T3_BPCCombo.ValueMember = "Key"
    End Sub

    Private bpikp As New Dictionary(Of SDK.BitsPerInch, String) From
    {
        {SDK.BitsPerInch.Default, "Default"},
        {SDK.BitsPerInch.BPI210, "210"},
        {SDK.BitsPerInch.BPI75, "75"}
    }

    Private Sub InitBPICombos()
        T1_BPICombo.DataSource = New BindingSource(bpikp, Nothing)
        T1_BPICombo.DisplayMember = "Value"
        T1_BPICombo.ValueMember = "Key"
        T2_BPICombo.DataSource = New BindingSource(bpikp, Nothing)
        T2_BPICombo.DisplayMember = "Value"
        T2_BPICombo.ValueMember = "Key"
        T3_BPICombo.DataSource = New BindingSource(bpikp, Nothing)
        T3_BPICombo.DisplayMember = "Value"
        T3_BPICombo.ValueMember = "Key"
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Local Methods ==="

    Private Sub CheckDataAvailable()
        EncodeMagButton.Enabled = Track1.Checked Or Track2.Checked Or Track3.Checked
    End Sub

    Private Sub ClearEncodingBoxButton_Click(sender As System.Object, e As System.EventArgs) _
                Handles ClearEncodingBoxButton.Click
        EncodingBox.Clear()
    End Sub

    Private Sub Track1_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles Track1.CheckedChanged
        'Enable/Disable the appropriate controls according to the selection
        If hSession <> 0 Then
            Track1Label.Enabled = Track1.Checked
            Track1SettingsLabel.Enabled = Track1.Checked
            Track1Data.Enabled = Track1.Checked
            T1_BPCCombo.Enabled = Track1.Checked
            T1_BPICombo.Enabled = Track1.Checked

            CheckDataAvailable()
        End If
    End Sub

    Private Sub Track2_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles Track2.CheckedChanged
        'Enable/Disable the appropriate controls according to the selection
        If hSession <> 0 Then
            Track2Label.Enabled = Track2.Checked
            Track2SettingsLabel.Enabled = Track2.Checked
            Track2Data.Enabled = Track2.Checked
            T2_BPCCombo.Enabled = Track2.Checked
            T2_BPICombo.Enabled = Track2.Checked

            CheckDataAvailable()
        End If
    End Sub

    Private Sub Track3_CheckedChanged(sender As System.Object, e As System.EventArgs) _
                Handles Track3.CheckedChanged
        'Enable/Disable the appropriate controls according to the selection
        If hSession <> 0 Then
            Track3Label.Enabled = Track3.Checked
            Track3SettingsLabel.Enabled = Track3.Checked
            Track3Data.Enabled = Track3.Checked
            T3_BPCCombo.Enabled = Track3.Checked
            T3_BPICombo.Enabled = Track3.Checked

            CheckDataAvailable()
        End If
    End Sub

    Private Sub EncodingTypeBox_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) _
                Handles EncodingTypeCombo.SelectedIndexChanged
        'Enable/Disable appropriate controls according to ISO or JIS2 being selected
        Dim visible As Boolean = (EncodingTypeCombo.SelectedIndex = 0)        'TRUE if ISO, FALSE if JIS2

        Track1Data.Visible = visible
        Track1.Visible = visible
        Track2Data.Visible = visible
        Track2.Visible = visible
        Track3Data.Visible = visible
        Track3.Visible = visible
        Track1Label.Visible = visible
        Track2Label.Visible = visible
        Track3Label.Visible = visible
        Track1SettingsLabel.Visible = visible
        Track2SettingsLabel.Visible = visible
        Track3SettingsLabel.Visible = visible

        T1_BPCCombo.Visible = visible
        T1_BPICombo.Visible = visible
        T2_BPCCombo.Visible = visible
        T2_BPICombo.Visible = visible
        T3_BPCCombo.Visible = visible
        T3_BPICombo.Visible = visible
        BitsPerCharLabel.Visible = visible
        BitsPerInchLabel.Visible = visible

        'JIS2 labels are the opposite of ISO labels
        JIS2Label.Visible = Not visible

        Track1Read.Visible = visible
        Track2Read.Visible = visible
        Track3Read.Visible = visible
        ReadMagTracks.Visible = visible
    End Sub

    Private Sub EncodingGetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles EncodingGetRadio.CheckedChanged
        MagStartPosition.Enabled = False
    End Sub

    Private Sub EncodingSetRadio_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles EncodingSetRadio.CheckedChanged
        MagStartPosition.Enabled = True
    End Sub
#End Region

    '----------------------------------------------------------------------

#Region "=== Encode Mag Stripe ==="

    Const ISO_7_BIT_START_SENTINEL As String = "%"
    Const ISO_5_BIT_START_SENTINEL As String = ";"
    Const ISO_END_SENTINEL As String = "?"
    Const JIS2_SENTINEL As String = "\x7f"

    Private Sub EncodeMagButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles EncodeMagButton.Click
        Dim Encode As New SDK.MagDef

        Encode.EncodingSpec = EncodingTypeCombo.SelectedItem.Key
        If Verify.Checked Then
            Encode.Verify = SDK.Verify.On
        Else
            Encode.Verify = SDK.Verify.Off
        End If
        Encode.Coercivity = CoercivityCombo.SelectedItem.Key

        If Encode.EncodingSpec = SDK.EncodingSpec.JIS2 Then
            Encode.Track(0).CharCount = Track1Data.TextLength
            Encode.Track(0).Data = JIS2_SENTINEL + Track1Data.Text + JIS2_SENTINEL
        Else
            If Track1.Checked Then
                If Encode.EncodingSpec = SDK.EncodingSpec.ISO Then
                    Encode.Track(0).Data = ISO_7_BIT_START_SENTINEL + Track1Data.Text + ISO_END_SENTINEL
                Else
                    Encode.Track(0).Data = Track1Data.Text
                End If
                Encode.Track(0).CharCount = Track1Data.TextLength
                Encode.Track(0).BitsPerChar = T1_BPCCombo.SelectedItem.Key
                Encode.Track(0).BitsPerInch = T1_BPICombo.SelectedItem.Key
            End If

            If Track2.Checked Then
                If Encode.EncodingSpec = SDK.EncodingSpec.ISO Then
                    Encode.Track(1).Data = ISO_5_BIT_START_SENTINEL + Track2Data.Text + ISO_END_SENTINEL
                Else
                    Encode.Track(1).Data = Track2Data.Text
                End If
                Encode.Track(1).CharCount = Track2Data.TextLength
                Encode.Track(1).BitsPerChar = T2_BPCCombo.SelectedItem.Key
                Encode.Track(1).BitsPerInch = T2_BPICombo.SelectedItem.Key
            End If

            If Track3.Checked Then
                If Encode.EncodingSpec = SDK.EncodingSpec.ISO Then
                    Encode.Track(2).Data = ISO_5_BIT_START_SENTINEL + Track3Data.Text + ISO_END_SENTINEL
                Else
                    Encode.Track(2).Data = Track3Data.Text
                End If
                Encode.Track(2).CharCount = Track3Data.TextLength
                Encode.Track(2).BitsPerChar = T3_BPCCombo.SelectedItem.Key
                Encode.Track(2).BitsPerInch = T3_BPICombo.SelectedItem.Key
            End If
        End If

        Dim SDKReturn As SDK.Return = SDK.ID_EncodeMag(hSession, Encode)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("EncodeMagStripe", SDKReturn)
        Else
            WaitForPrinterToFinish()
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Display Mag Data ==="

    Private Sub DisplayUltimaMag(MagData As SDK.MagData2, Optional Tracks As SDK.TrackID = SDK.TrackID.AllTracks)
        Dim EncodingSpec As SDK.EncodingSpec = EncodingTypeCombo.SelectedItem.Key

        If Tracks.HasFlag(SDK.TrackID.Track1) Then
            EncodingBox.AppendText("(1): " + MagData.tk1 + Environment.NewLine)
        End If

        If EncodingSpec = SDK.EncodingSpec.ISO Then
            If Tracks.HasFlag(SDK.TrackID.Track2) Then
                EncodingBox.AppendText("(2): " + MagData.tk2 + Environment.NewLine)
            End If
            If Tracks.HasFlag(SDK.TrackID.Track3) Then
                EncodingBox.AppendText("(3): " + MagData.tk3 + Environment.NewLine)
            End If
        End If
        EncodingBox.AppendText(Environment.NewLine)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Read Mag Data (3 tracks) ==="

    Private Sub ReadMagButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ReadMagButton.Click
        Dim EncodingSpec As SDK.EncodingSpec = EncodingTypeCombo.SelectedItem.Key

        Dim MagData As New SDK.MagData2
        Dim SDKReturn As SDK.Return = SDK.ID_ReadMag(hSession, MagData, EncodingSpec)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("ReadMagStripe", SDKReturn)
        Else
            DisplayUltimaMag(MagData)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Read Mag Tracks ==="

    Private Sub ReadMagTracks_Click(sender As System.Object, e As System.EventArgs) _
                Handles ReadMagTracks.Click
        Dim Tracks As SDK.TrackID = 0
        If Track1Read.Checked Then Tracks = Tracks Or SDK.TrackID.Track1
        If Track2Read.Checked Then Tracks = Tracks Or SDK.TrackID.Track2
        If Track3Read.Checked Then Tracks = Tracks Or SDK.TrackID.Track3

        If Tracks = 0 Then Return

        Dim EncodingSpec As SDK.EncodingSpec = EncodingTypeCombo.SelectedItem.Key

        Dim MagData As New SDK.MagData2
        Dim SDKReturn As SDK.Return = SDK.ID_ReadMagTracks(hSession, MagData, EncodingSpec, Tracks)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("ReadMagTracks", SDKReturn)

        Else
            DisplayUltimaMag(MagData, Tracks)
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Mag Start Position ==="

    Private Function GetMagStart(ByRef MagStart As Integer) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_MagStart(hSession, SDK.Action.Read, MagStart)
        If SDKReturn <> SDK.Return.Success Then
            HandleError("MagStart", SDKReturn)
        Else
            MagStartToControl(MagStart)
        End If
        Return SDKReturn
    End Function

    Private Sub MagStartToControl(MagStart As Integer)
        MagStartPosition.Value = MagStart
    End Sub

    Private Sub MagStartToMsgBox(MagStart As Integer, Action As SDK.Action)
        EncodingBox.AppendText("MagStart" + Separator(Action) + MagStart.ToString())
        EncodingBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub MagStartButton_Click(sender As System.Object, e As System.EventArgs) Handles MagStartButton.Click
        Dim MagStart As New Integer

        If EncodingGetRadio.Checked Then
            If GetMagStart(MagStart) = SDK.Return.Success Then
                MagStartToMsgBox(MagStart, SDK.Action.Read)
            Else
                'Call the SDK to write to the driver
                MagStart = Decimal.ToInt32(MagStartPosition.Value)

                Dim SDKReturn As SDK.Return = SDK.ID_MagStart(hSession, SDK.Action.Write, MagStart)
                If SDKReturn <> SDK.Return.Success Then
                    HandleError("SetMagStart", SDKReturn)
                Else
                    MagStartToMsgBox(MagStart, SDK.Action.Write)
                End If
            End If
        End If

    End Sub

#End Region

End Class
